(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17490,        592]*)
(*NotebookOutlinePosition[     18554,        628]*)
(*  CellTagsIndexPosition[     18466,        622]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Using DSolve\n",
  StyleBox["(Modified 1/7/95 CCR)",
    FontSize->9,
    FontWeight->"Plain"],
  ""
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " is ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s built-in differential equations solver. At this stage (Version 2.2), \
the solver is greatly improved, but yet not really sophisticated. It is \
useful, but you easily reach its limitations. In this notebook we see how to \
use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " effectively for single linear differential equations of first and higher \
order.  \n\n",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " can solve many forms of differential equations (as long as the \
integrations can be done in closed form), and it can solve many ",
  StyleBox["n-th order linear constant coefficients",
    FontVariations->{"Underline"->True}],
  " differential equations.  The solver cannot always solve such equations \
beyond order four because the general (characteristic) polynomial of order \
greater than four has no closed form solution.\n\nWe will look at systems of \
equations in a subsequent notebook."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["What DSolve says about itself"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "(I have copied ",
  StyleBox["DSolve::usage",
    FontWeight->"Bold"],
  " as an initialization cell from Info.m into this notebook as an \
initialization cell.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<DSolve\>", LongForm \[Rule] False]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"\<\"DSolve[eqn, y, x] solves a differential equation for the \
function y, with independent variable x. DSolve[{eqn1, eqn2, ...  }, {y1, y2, \
...  }, x] solves a list of differential equations. DSolve[eqn, y, {x1, x2, \
... }] solves a partial differential equation.\"\>", " ", 
      ButtonBox[
        StyleBox["More\[Ellipsis]",
          "SR"],
        ButtonData:>"DSolve",
        Active->True,
        ButtonStyle->"RefGuideLink"]}]], "Print",
  CellTags->"Info3306945818-2545125"]
}, Closed]],

Cell[TextData[
"DSolve[eqn, y[x], x] solves a differential equation for\n   the functions \
y[x], with independent variable x.\n   DSolve[{eqn1, eqn2, ...}, {y1[x1, \
...], ...}, {x1,\n   ...}] solves a list of differential equations."], "Info",\

  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["Note the use of == in all of the equations",
    FontVariations->{"Underline"->True}],
  ". This is very important: if you inadvertantly use =, a substitution will \
be made, and DSolve will complain. But when you attempt to change to the \
correct form \"==\", the substitution you made will cause this parameter to \
read \"",
  StyleBox["True",
    FontVariations->{"Underline"->True}],
  "\", and DSolve will make more complaints. These errors are illustrated \
below."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Using DSolve (single equation, no initial conditions)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The parameters in ",
  StyleBox["DSolve[eqn,y[x],x] ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "have these meanings:\n\[Bullet]  eqn is expressed, for example, in terms \
of y[x], y'[x], ...,etc;\n\[Bullet]  y[x] is the form of the desired solution \
function,\n\[Bullet]  and x is the name of the independent variable."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["An Example"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Solve this problem: (Must be homogeneous since second order.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["y", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}], "+", \(y[x]\)}], "==",
           "0"}], ",", \(y[x]\), ",", "x"}], "]"}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{y[x] \[Rule] C[1]\ Cos[x] + C[2]\ Sin[x]}}\)], "Output"]
}, Closed]],

Cell[TextData["Now change the various labels:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[z, t]\), "\n", 
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["z", "\[DoublePrime]",
                MultilineFunction->None], "[", "t", "]"}], "+", \(z[t]\)}], "==",
           "0"}], ",", \(z[t]\), ",", "t"}], "]"}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{z[t] \[Rule] C[1]\ Cos[t] + C[2]\ Sin[t]}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoefficientList[
      z[t] /. %\[LeftDoubleBracket]1\[RightDoubleBracket], {C[1], 
        C[2]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, Sin[t]}, {Cos[t], 0}}\)], "Output"]
}, Closed]],

Cell[TextData[
"The labels used in the solution have changed, but not the solution, \
itself."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Using DSolve (single equation with initial conditions)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "When auxiliary conditions are to be included in addition to the \
differential equation, use the form ",
  StyleBox["{eqn, auxiliary}",
    FontWeight->"Bold"],
  ". For instance, see this example:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["An Example"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Solve this problem: (First order, so may be nonhomogeneous.)"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}], 
                "-", \(5\ y[x]\)}], "==", \(Sin[3\ x]\)}], 
            ",", \(y[0] == 4\)}], "}"}], ",", \(y[x]\), ",", "x"}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{y[x] \[Rule] 
          1\/34\ \((139\ \[ExponentialE]\^\(5\ x\) - 3\ Cos[3\ x] - 
                5\ Sin[3\ x])\)}}\)], "Output"]
}, Closed]],

Cell[TextData["Again, change the various labels:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["z", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], 
                "-", \(5\ z[t]\)}], "==", \(Sin[3\ t]\)}], 
            ",", \(z[0] == 4\)}], "}"}], ",", \(z[t]\), ",", "t"}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{z[t] \[Rule] 
          1\/34\ \((139\ \[ExponentialE]\^\(5\ t\) - 3\ Cos[3\ t] - 
                5\ Sin[3\ t])\)}}\)], "Output"]
}, Closed]],

Cell[TextData[
"Once again, the labels used in the solution have changed, but not the \
solution, itself."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Using DSolve (single equation, boundary conditions)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Examples"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Unique solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["We did this problem earlier: "], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}], 
                    "+", \(y[x]\)}], "==", "0"}], ",", \(y[0] == 0\), 
                ",", \(y[\[Pi]\/2] == \(-5\)\)}], "}"}], ",", \(y[x]\), ",", 
            "x"}], "]"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({y[x] \[Rule] \(-5\)\ Sin[x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Lots of solutions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}], 
                    "+", \(y[x]\)}], "==", "0"}], ",", \(y[0] == 0\), 
                ",", \(y[\[Pi]] == 0\)}], "}"}], ",", \(y[x]\), ",", "x"}], 
          "]"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({y[x] \[Rule] C[2]\ Sin[x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["No solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[DoublePrime]",
                      MultilineFunction->None], "[", "x", "]"}], 
                  "+", \(y[x]\)}], "==", "0"}], ",", \(y[0] == 0\), 
              ",", \(y[\[Pi]] == 1\)}], "}"}], ",", \(y[x]\), ",", "x"}], 
        "]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(DSolve::"bvnul" \(\(:\)\(\ \)\) 
      "For some branches of the general solution, the given boundary \
conditions lead to an empty solution."\)], "Message"],

Cell[BoxData[
    \({}\)], "Output"]
}, Closed]],

Cell[TextData[
"That boundary value problems for the same linear homogeneous differential \
equation permit all of these cases to happen should indicate to us that we \
had better be careful as we study boundary value problems. Because of the \
variety of things which  can happen, these problems are particularly \
interesting objects for study. They also have exceedingly important \
applications."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"More DSolve (one equation, unusual boundary conditions)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Once one has ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to perform the tedious calculations, it is easy to look at non-standard \
boundary value problems. Many of these would provide fruitful objects for \
further study."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["One slope, rather than one point"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}], 
                    "+", \(y[x]\)}], "==", "0"}], ",", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "0", "]"}], "==", 
                  "1"}]}], "}"}], ",", \(y[x]\), ",", "x"}], "]"}], 
        "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({y[x] \[Rule] C[1]\ Cos[x] + Sin[x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Two slopes"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}], 
                    "+", \(y[x]\)}], "==", "0"}], ",", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "0", "]"}], "==", "1"}], 
                ",", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", \(\[Pi]\/2\), "]"}], "==",
                   "2"}]}], "}"}], ",", \(y[x]\), ",", "x"}], "]"}], 
        "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({y[x] \[Rule] \(-2\)\ Cos[x] + Sin[x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["One slope and one point"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[{\(Clear[x, y]\), "\n", 
    RowBox[{"soln", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      SuperscriptBox["y", "\[DoublePrime]",
                        MultilineFunction->None], "[", "x", "]"}], 
                    "+", \(y[x]\)}], "==", "0"}], ",", 
                RowBox[{
                  RowBox[{
                    SuperscriptBox["y", "\[Prime]",
                      MultilineFunction->None], "[", "0", "]"}], "==", "1"}], 
                ",", \(y[\[Pi]] == 3\)}], "}"}], ",", \(y[x]\), ",", "x"}], 
          "]"}], "\[LeftDoubleBracket]", "1", 
        "\[RightDoubleBracket]"}]}]}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({y[x] \[Rule] \(-3\)\ Cos[x] + Sin[x]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["For Further Thought"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"It is not difficult to modify each of these kinds of problems so that there \
is no solution and so that there are infinitely many solutions. Do so."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{572, 573},
WindowMargins->{{57, Automatic}, {Automatic, 7}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3306945818-2545125"->{
    Cell[3586, 113, 516, 11, 87, "Print",
      CellTags->"Info3306945818-2545125"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3306945818-2545125", 18355, 615}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 184, 8, 95, "Subtitle",
  Evaluatable->False],
Cell[1963, 63, 1109, 26, 212, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3097, 93, 107, 2, 56, "Section",
  Evaluatable->False],
Cell[3207, 97, 242, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3474, 109, 109, 2, 27, "Input"],
Cell[3586, 113, 516, 11, 87, "Print",
  CellTags->"Info3306945818-2545125"]
}, Closed]],
Cell[4117, 127, 296, 6, 72, "Info",
  Evaluatable->False],
Cell[4416, 135, 562, 13, 86, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[5015, 153, 132, 3, 36, "Section",
  Evaluatable->False],
Cell[5150, 158, 414, 10, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5589, 172, 91, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5683, 176, 137, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5845, 183, 361, 9, 43, "Input"],
Cell[6209, 194, 78, 1, 27, "Output"]
}, Closed]],
Cell[6302, 198, 105, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6432, 204, 361, 9, 43, "Input"],
Cell[6796, 215, 78, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6911, 221, 158, 4, 27, "Input"],
Cell[7072, 227, 60, 1, 27, "Output"]
}, Closed]],
Cell[7147, 231, 153, 4, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7349, 241, 133, 3, 36, "Section",
  Evaluatable->False],
Cell[7485, 246, 278, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7788, 258, 91, 2, 46, "Subsection",
  Evaluatable->False],
Cell[7882, 262, 136, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8043, 269, 459, 13, 27, "Input"],
Cell[8505, 284, 152, 3, 42, "Output"]
}, Closed]],
Cell[8672, 290, 108, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8805, 296, 459, 13, 27, "Input"],
Cell[9267, 311, 152, 3, 42, "Output"]
}, Closed]],
Cell[9434, 317, 165, 4, 32, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9648, 327, 130, 3, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9803, 334, 89, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9917, 340, 99, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[10019, 344, 104, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10148, 350, 667, 16, 72, "Input"],
Cell[10818, 368, 63, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10930, 375, 101, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11056, 381, 657, 16, 59, "Input"],
Cell[11716, 399, 61, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11826, 406, 95, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11946, 412, 553, 14, 43, "Input"],
Cell[12502, 428, 177, 3, 49, "Message"],
Cell[12682, 433, 36, 1, 27, "Output"]
}, Closed]],
Cell[12733, 437, 459, 8, 86, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13253, 452, 134, 3, 36, "Section",
  Evaluatable->False],
Cell[13390, 457, 317, 9, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13732, 470, 116, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13873, 476, 792, 19, 43, "Input"],
Cell[14668, 497, 70, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14787, 504, 94, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14906, 510, 1006, 24, 72, "Input"],
Cell[15915, 536, 72, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16036, 543, 107, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16168, 549, 825, 20, 59, "Input"],
Cell[16996, 571, 72, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17117, 578, 103, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[17223, 582, 227, 5, 70, "Text"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

